/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.ChangelogRecordDeserializationHelper;
import org.apache.kafka.streams.query.Position;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.StoreQueryUtils;

public class MemoryLRUCache
implements KeyValueStore<Bytes, byte[]> {
    private final Position position = Position.emptyPosition();
    private final String name;
    protected final Map<Bytes, byte[]> map;
    private boolean restoring = false;
    private volatile boolean open = true;
    protected StateStoreContext context;
    private EldestEntryRemovalListener listener;

    MemoryLRUCache(String name, final int maxCacheSize) {
        this.name = name;
        this.map = new LinkedHashMap<Bytes, byte[]>(maxCacheSize + 1, 1.01f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<Bytes, byte[]> eldest) {
                boolean evict;
                boolean bl = evict = super.size() > maxCacheSize;
                if (evict && !MemoryLRUCache.this.restoring && MemoryLRUCache.this.listener != null) {
                    MemoryLRUCache.this.listener.apply(eldest.getKey(), eldest.getValue());
                }
                return evict;
            }
        };
    }

    void setWhenEldestRemoved(EldestEntryRemovalListener listener) {
        this.listener = listener;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void init(StateStoreContext stateStoreContext, StateStore root) {
        boolean consistencyEnabled = StreamsConfig.InternalConfig.getBoolean(stateStoreContext.appConfigs(), "__iq.consistency.offset.vector.enabled__", false);
        stateStoreContext.register(root, records -> {
            this.restoring = true;
            Position position = this.position;
            synchronized (position) {
                for (ConsumerRecord record : records) {
                    this.put(Bytes.wrap((byte[])((byte[])record.key())), (byte[])record.value());
                    ChangelogRecordDeserializationHelper.applyChecksAndUpdatePosition((ConsumerRecord<byte[], byte[]>)record, consistencyEnabled, this.position);
                }
            }
            this.restoring = false;
        });
        this.context = stateStoreContext;
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public synchronized byte[] get(Bytes key) {
        Objects.requireNonNull(key);
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void put(Bytes key, byte[] value) {
        Objects.requireNonNull(key);
        Position position = this.position;
        synchronized (position) {
            if (value == null) {
                this.delete(key);
            } else {
                this.map.put(key, value);
            }
            StoreQueryUtils.updatePosition(this.position, this.context);
        }
    }

    @Override
    public synchronized byte[] putIfAbsent(Bytes key, byte[] value) {
        Objects.requireNonNull(key);
        byte[] originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    @Override
    public void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        for (KeyValue<Bytes, byte[]> entry : entries) {
            this.put((Bytes)entry.key, (byte[])entry.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] delete(Bytes key) {
        Objects.requireNonNull(key);
        Position position = this.position;
        synchronized (position) {
            StoreQueryUtils.updatePosition(this.position, this.context);
            return this.map.remove(key);
        }
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        throw new UnsupportedOperationException("MemoryLRUCache does not support range() function.");
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseRange(Bytes from, Bytes to) {
        throw new UnsupportedOperationException("MemoryLRUCache does not support reverseRange() function.");
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> all() {
        throw new UnsupportedOperationException("MemoryLRUCache does not support all() function.");
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> reverseAll() {
        throw new UnsupportedOperationException("MemoryLRUCache does not support reverseAll() function.");
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefixScan(P prefix, PS prefixKeySerializer) {
        throw new UnsupportedOperationException("MemoryLRUCache does not support prefixScan() function.");
    }

    @Override
    public long approximateNumEntries() {
        return this.map.size();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.open = false;
    }

    public int size() {
        return this.map.size();
    }

    public static interface EldestEntryRemovalListener {
        public void apply(Bytes var1, byte[] var2);
    }
}

